//
//  LoadingView.m
//  NaviDemo
//
//  Created by linbiao on 2019/5/10.
//  Copyright © 2019年 Baidu. All rights reserved.
//

#import "LoadingView.h"
#import "LoadingNonBlockingView.h"
#import "MapCommonDefine.h"
#import "WeakTimerTarget.h"

@interface LoadingView ()

@property (nonatomic, strong) UIView *contentView;
@property (nonatomic, strong) UILabel *tipsView;
@property (nonatomic, strong) NSTimer *timer;
@property (nonatomic, copy) TimeOut timeOut;

@property (nonatomic, strong) LoadingNonBlockingView *customMessageView;

@end

@implementation LoadingView

- (id)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (self) {
        [self initViewWithFrame:frame];
        [self addNotification];
    }
    return self;
}

- (void)dealloc {
    [self stopAnimation];
    [self removeNotification];
}

#pragma mark - Notification
- (void)addNotification {
    [[NSNotificationCenter defaultCenter] addObserver:self
                                             selector:@selector(enterBackgroundNotification:)
                                                 name:UIApplicationDidEnterBackgroundNotification
                                               object:nil];
    [[NSNotificationCenter defaultCenter] addObserver:self
                                             selector:@selector(becomeActiveNotification:)
                                                 name:UIApplicationDidBecomeActiveNotification
                                               object:nil];
}

- (void)removeNotification {
    [[NSNotificationCenter defaultCenter] removeObserver:self
                                                    name:UIApplicationDidEnterBackgroundNotification
                                                  object:nil];
    [[NSNotificationCenter defaultCenter] removeObserver:self
                                                    name:UIApplicationDidBecomeActiveNotification
                                                  object:nil];
}

- (void)enterBackgroundNotification:(NSNotification *)notification {
    [self stopAnimation];
}

- (void)becomeActiveNotification:(NSNotification *)notification {
    [self startAnimation];
}

#define kContentViewWidth 115
#define kContentViewHeight 32
#define kContentViewDis 5

#pragma mark - 初始化界面
- (void)initViewWithFrame:(CGRect)frame {
    LoadingNonBlockingView *customMessageView = [[LoadingNonBlockingView alloc] initWithFrame:CGRectMake((self.width - 57)/2.f, (self.height - 57)/2.f, 57, 57)];
    [self addSubview:customMessageView];
    _customMessageView = customMessageView;
    
    // 创建完成，开始loading
    [self startAnimation];
    
    //下部增加一个文案
    _contentView = [[UIView alloc]initWithFrame:CGRectMake((frame.size.width - kContentViewWidth)/2.0f, CGRectGetMaxY(_customMessageView.frame)+kContentViewDis, kContentViewWidth, kContentViewHeight)];
    [self addSubview:_contentView];
    
    _tipsView = [[UILabel alloc]initWithFrame:CGRectMake(0, kContentViewDis, kContentViewWidth, kContentViewHeight)];
    [_tipsView setText:@"加载中..."];
    [_tipsView setTextColor:UIColorFromRGBA(0x666666, 1)];
    [_tipsView setFont:[UIFont systemFontOfSize:12.0f]];
    [self.tipsView sizeToFit];
    [_contentView addSubview:_tipsView];
    
    float width = _tipsView.frame.size.width;
    _contentView.frame = CGRectMake((frame.size.width - width)/2.0f, CGRectGetMaxY(_customMessageView.frame)+kContentViewDis, width, kContentViewHeight);
    
    _contentView.hidden = YES;
}

- (void)setHidden:(BOOL)hidden{
    [super setHidden:hidden];
    if (hidden == YES) {
        [self stopAnimation];
    } else {
        [self startAnimation];
    }
}

#pragma mark -中间过程中更改卡片高度或者frame的
- (void) resetLoadingContentWhenFrameChange {
    if(_customMessageView){
        _customMessageView.frame = CGRectMake((self.width - 57)/2.f, (self.height - 57)/2.f, 57, 57);
    }
    
    if (self.contentView){
        self.contentView.frame = CGRectMake((self.width - kContentViewWidth)/2.0f, CGRectGetMaxY(_customMessageView.frame)+kContentViewDis, kContentViewWidth, kContentViewHeight);
    }
    
    if (self.tipsView && self.tipsView.text){
        float width = _tipsView.frame.size.width;
        _contentView.frame = CGRectMake((self.width - width)/2.0f, CGRectGetMaxY(_customMessageView.frame)+kContentViewDis, width, kContentViewHeight);
    }
}

#pragma mark - 动画控制
- (void)startAnimation {
    [_customMessageView startAnimation];
}

- (void)stopAnimation {
    [_customMessageView stopAnimaiton];
    [self stopTimer];
}

- (void)updateMessage:(NSString *)message withLabel:(BOOL)isShow {
    [_tipsView setText:message];
    [_tipsView sizeToFit];
    if (isShow) {
        _contentView.hidden = NO;
    } else {
        _contentView.hidden = YES;
    }
    _contentView.frame = CGRectMake((self.frame.size.width - _tipsView.frame.size.width)/2.0f, _contentView.frame.origin.y, _tipsView.frame.size.width, kContentViewHeight);
}

- (void)startAnimation:(NSInteger)time withTimeOutBlock:(void(^)(void))timeout {
    [self startAnimation];
    _timeOut = timeout;
    [self startTimer:time];
}

#pragma mark - 开启timeout
- (void)startTimer:(NSInteger)time {
    [self stopTimer];
    WeakTimerTarget *weakTarget = [[WeakTimerTarget alloc] initWithTarget: self andSelector: @selector(stopLoadingAction)];
    _timer = [NSTimer scheduledTimerWithTimeInterval:time
                                              target:weakTarget
                                            selector:@selector(timerDidFire:)
                                            userInfo:nil
                                             repeats:NO];
    [[NSRunLoop currentRunLoop]addTimer:_timer forMode:NSRunLoopCommonModes];
}

- (void)stopTimer {
    if (_timer != nil) {
        [_timer invalidate];
        _timer = nil;
    }
}

- (void)stopLoadingAction {
    [self stopAnimation];
    if (_timeOut) {
        _timeOut();
    }
}

@end
