//
//  LoadingNonBlockingView.m
//  NaviDemo
//
//  Created by linbiao on 2019/5/13.
//  Copyright © 2019年 Baidu. All rights reserved.
//

#import "LoadingNonBlockingView.h"
#import "MapCommonDefine.h"

#define kRoundLayer1AnimationKey    @"RoundLayer1AnimationKey"
#define kRoundLayer2AnimationKey    @"RoundLayer2AnimationKey"
#define kImageLayerAnimationKey     @"ImageLayerAnimationKey"

@interface LoadingNonBlockingView () <CAAnimationDelegate>

@property (nonatomic, assign) BOOL isBlock; //判断是否是阻塞还是非阻塞loading

@property (nonatomic, strong) CALayer *roundLayer1;
@property (nonatomic, strong) CALayer *roundLayer2;
@property (nonatomic, strong) CALayer *imageLayer;

@property (nonatomic, strong) CAAnimationGroup *groupAnimation1;
@property (nonatomic, strong) CAAnimationGroup *groupAnimation2;
@property (nonatomic, strong) CAKeyframeAnimation *animation3;

@end

#define kImageViewWidth 57
#define kImageViewHeight 57

@implementation LoadingNonBlockingView

- (instancetype)initWithFrame:(CGRect)frame {
    return [self initWithFrame:frame isBlock:NO];
}

- (instancetype)initWithFrame:(CGRect)frame isBlock:(BOOL)isBlock {
    self  = [super initWithFrame:frame];
    if (self) {
        // 初始化视图
        _roundLayer1 = [[CALayer alloc] init];
        [self.layer addSublayer:_roundLayer1];
        
        _roundLayer2 = [[CALayer alloc] init];
        [self.layer addSublayer:_roundLayer2];
        
        _imageLayer = [[CALayer alloc] init];
        [self.layer addSublayer:_imageLayer];
        
        self.isBlock = isBlock;
        [self createAnimation];
    }
    return self;
}

- (void)setIsBlock:(BOOL)isBlock {
    _isBlock = isBlock;
    // 设置默认图片和背景颜色
    UIColor *backgroundColor = nil;
    UIImage *backgroundImage = nil;
    CGFloat roundWidth = 0.f;
    CGFloat imageViewWidth = 0.f;
    if (self.isBlock) {
        backgroundColor = UIColorFromRGB(0x5095FF);
        backgroundImage = [UIImage imageNamed:@"icon_waterdrop_blue"];
        roundWidth = 13;
        imageViewWidth = 44;
    } else {
        backgroundColor = UIColorFromRGB(0x929292);
        backgroundImage = [UIImage imageNamed:@"icon_waterdrop_gray"];
        roundWidth = 14;
        imageViewWidth = 57;
    }
    [_roundLayer1 setBackgroundColor:backgroundColor.CGColor];
    [_roundLayer2 setBackgroundColor:backgroundColor.CGColor];
    
    [_roundLayer1 setFrame:CGRectMake((self.width - roundWidth)/2.f, (self.height - roundWidth)/2.f, roundWidth, roundWidth)];
    _roundLayer1.cornerRadius = roundWidth / 2.f;
    
    [_roundLayer2 setFrame:_roundLayer1.frame];
    _roundLayer2.cornerRadius = roundWidth / 2.f;
    
    _imageLayer.contents = (__bridge id _Nullable)(backgroundImage.CGImage);
    [_imageLayer setFrame:CGRectMake((self.width - imageViewWidth)/ 2.f, (self.height - imageViewWidth)/2.f, imageViewWidth, imageViewWidth)];
}

- (void)startAnimation {
    if ([_roundLayer1 animationForKey:kRoundLayer1AnimationKey] == nil) {
        [_roundLayer1 addAnimation:_groupAnimation1 forKey:kRoundLayer1AnimationKey];
    }
    if ([_roundLayer2 animationForKey:kRoundLayer2AnimationKey] == nil) {
        [_roundLayer2 addAnimation:_groupAnimation2 forKey:kRoundLayer2AnimationKey];
    }
    if ([_imageLayer animationForKey:kImageLayerAnimationKey] == nil) {
        [_imageLayer addAnimation:_animation3 forKey:kImageLayerAnimationKey];
    }
}

- (void)stopAnimaiton {
    // 移除所有的动画
    if ([_roundLayer1 animationForKey:kRoundLayer1AnimationKey] != nil) {
        [_roundLayer1 removeAnimationForKey:kRoundLayer1AnimationKey];
    }
    if ([_roundLayer2 animationForKey:kRoundLayer2AnimationKey] != nil) {
        [_roundLayer2 removeAnimationForKey:kRoundLayer2AnimationKey];
    }
    if ([_imageLayer animationForKey:kImageLayerAnimationKey]  != nil) {
        [_imageLayer removeAnimationForKey:kImageLayerAnimationKey];
    }
}

#pragma mark private method

- (void)createAnimation {
    // 给第一个实心layer添加动画
    CAKeyframeAnimation *scaleAnimation1 = [self createAnimationWithKeyTimes:@[@(0),@(0.25)] KeyValues:@[@(1.0),@(self.isBlock?3.2:3.8)] keyPaths:@"transform.scale" timingFunction:kCAMediaTimingFunctionEaseInEaseOut];
    CAKeyframeAnimation *opactiyAnimation1 = [self createAnimationWithKeyTimes:@[@(0),@(0.25)] KeyValues:@[@(0.5),@(0.0)] keyPaths:@"opacity" timingFunction:kCAMediaTimingFunctionEaseInEaseOut];
    _groupAnimation1 = [self createAnimationGroupWithBeginTime:0 WithAnimations:@[scaleAnimation1,opactiyAnimation1]];
    
    // 给第二个实心layer添加动画,延迟执行
    CAKeyframeAnimation *scaleAnimation2 = [self createAnimationWithKeyTimes:@[@(0.27),@(0.74)] KeyValues:@[@(1.0),@(self.isBlock?3.2:3.8)] keyPaths:@"transform.scale" timingFunction:kCAMediaTimingFunctionEaseInEaseOut];
    CAKeyframeAnimation *opactiyAnimation2 = [self createAnimationWithKeyTimes:@[@(0.27),@(0.74)] KeyValues:@[@(0.5),@(0.0)] keyPaths:@"opacity" timingFunction:kCAMediaTimingFunctionEaseInEaseOut];
    _groupAnimation2 = [self createAnimationGroupWithBeginTime:0 WithAnimations:@[scaleAnimation2,opactiyAnimation2]];
    
    // 给水滴添加动画
    _animation3 = [self createAnimationWithKeyTimes:@[@(0.64),@(0.82),@(1.0)] KeyValues:@[@(1.0),@(self.isBlock?0.66:0.83),@(1.0)] keyPaths:@"transform.scale" timingFunction:kCAMediaTimingFunctionEaseInEaseOut];
}

- (CAKeyframeAnimation *)createAnimationWithKeyTimes:(NSArray *)keyTimes KeyValues:(NSArray *)keyValues keyPaths:(NSString *)keyPaths timingFunction:(NSString *)timeingFunction{
    
    CAKeyframeAnimation *keyAnima=[CAKeyframeAnimation animation];
    keyAnima.keyPath=keyPaths;
    keyAnima.duration=2;
    keyAnima.keyPath = keyPaths;
    keyAnima.keyTimes = keyTimes;
    keyAnima.values = keyValues;
    keyAnima.fillMode=kCAFillModeForwards;
    keyAnima.repeatCount = INT_MAX;
    keyAnima.timingFunction = [CAMediaTimingFunction functionWithName:timeingFunction];
    
    return keyAnima;
}

- (CAAnimationGroup *)createAnimationGroupWithBeginTime:(CFTimeInterval)time WithAnimations:(NSArray *)animations{
    CAAnimationGroup *groupAnimation = [CAAnimationGroup animation];
    groupAnimation.beginTime = time;
    groupAnimation.duration = 2;
    groupAnimation.repeatCount = INT_MAX;//FLT_MAX;  //"forever";
    groupAnimation.fillMode = kCAFillModeForwards;
    groupAnimation.animations = animations;
    return groupAnimation;
}

@end
