//
//  BNaviUtil.h
//  ChatAgentApp
//
//  Created by caoshiqian on 2025/4/22.
//

#import <Foundation/Foundation.h>
#import "BNaviService.h"
#import "BNUtility.h"
#import "BNCommonDef.h"
#import <BaiduMapAPI_Base/BMKBaseComponent.h>

/**
 百度地图SDK注册使用指导：
 - 账号注册 https://lbsyun.baidu.com/faq/search?id=299&title=875
 - 创建应用 https://lbsyun.baidu.com/faq/search?id=299&title=677
 - 导航SDK https://lbsyun.baidu.com/faq/api?title=ios-navsdk
 - 地图SDK https://lbsyun.baidu.com/faq/api?title=iossdk
 */

#ifdef DEBUG
#define BNAVI_APP_KEY @"" // replace with your app's AK
#else
#define BNAVI_APP_KEY @"" // replace with your app's AK
#endif

@protocol BNNaviSoundDelegate;

typedef NS_ENUM(NSInteger, BNaviInitState) {
    BNaviInitStateNotInit,
    BNaviInitStateIniting,
    BNaviInitStateInited,
    BNaviInitStateInitFailed,
};

@interface BNaviUtil : NSObject

@property (atomic, assign, readonly) BNaviInitState mapInitState;
@property (atomic, assign, readonly) BNaviInitState naviInitState;

+ (instancetype)sharedInstance;

// 只需要地图能力时调用
- (void)initMap;

// 需要导航能力时, 在 initMap 之后调用
- (void)initNavi;

// 设置导航音频代理，SDK需要在鉴权之后再设置
- (void)setSoundDelegate:(id<BNNaviSoundDelegate>)delegate;

// app启动后，导航sdk初始化完成，并且app获取到定位权限后，设置为YES。设置为YES后，导航SDK内部会开启定位。
- (void)setAlwaysUpdatingLocation:(BOOL)alwaysUpdatingLocation;

@end
