//
//  BCAMapNavigateModel.h
//  ChatAgentApp
//
//  Created by caoshiqian on 2025/4/21.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>
#import "BNCommonDef.h"

@class BCALocation;
@class BCALocationManager;

NS_ASSUME_NONNULL_BEGIN

extern NSString *const kMapNavigateParamTypeKey;
extern NSString *const kMapNavigateParamStartKey;
extern NSString *const kMapNavigateParamEndKey;
extern NSString *const kMapNavigateCurrentStartTitle;

typedef NS_ENUM(NSInteger, BCAMapNavigateType) {
    BCAMapNavigateTypeDrive,
    BCAMapNavigateTypeWalk,
    BCAMapNavigateTypeBike,
};

typedef NS_ENUM(NSInteger, BCAMapNavigateError) {
    BCAMapNavigateErrorNone = 0,
    
    BCAMapNavigateErrorNoLocationAuth = 1001,
    
    BCAMapNavigateErrorNoEndPosition = 3001,
    
    BCAMapNavigateErrorPoiCallFail = 4001,
    BCAMapNavigateErrorPoiSearchFail = 4002,
    BCAMapNavigateErrorRoutePlanFail = 4003,
};

@class BCAMapNavigateModel;

@protocol BCAMapNavigateModelDelegate <NSObject>

- (UIViewController *)mapNavigateModelGetChatViewController:(BCAMapNavigateModel *)model;

// 导航执行失败（通常在路线规划阶段）
- (void)mapNavigateModel:(BCAMapNavigateModel *)model finishWithError:(NSError *)error;

// 路线规划完成，外部可获取视图进行展示
- (void)mapNavigateModel:(BCAMapNavigateModel *)model routePlanDidFinished:(NSDictionary *)info;

// 外部TTS播报文本
- (void)mapNavigateModel:(BCAMapNavigateModel *)model onPlayTTS:(NSString *)text;

@end

@interface BCAMapNavigateModel : NSObject

@property (nonatomic, weak) id<BCAMapNavigateModelDelegate> delegate;

@property (nonatomic, assign) BCAMapNavigateType type;
@property (nonatomic, assign) BN_NaviType naviType;
@property (nonatomic, strong) BCALocation *startPosition;
@property (nonatomic, strong) NSMutableArray<BCALocation *> *endPositions; // 包含途经点

@property (nonatomic, strong, readonly) BCALocationManager *locationManager;

+ (instancetype)modelWithParams:(NSDictionary *)params;
- (instancetype)initWithParams:(NSDictionary *)params;

- (void)startRoutePlan;
- (void)enterNaviPage;
- (void)startNavigation;

- (void)startLocating;
- (void)stopLocating;

// 导航路线规划预览视图，用于在互动后展示在列表页
- (UIView *)routePlanPreviewView;

/**
 智能体语音状态发生变化
 @param state 0: stopeed; 1: speaking
 */
- (void)onAgentAudioStateChange:(int)state;

// private - start

- (void)locationManagerDidChangeAuthorizationStatus:(BOOL)authorized;
- (void)locationManagerDidUpdateLocation:(BCALocation *)location;
- (void)locationManagerDidFailWithError:(NSError *)error;

- (void)callbackFinishWithCode:(NSInteger)code error:(NSError *)error;
- (void)callbackFinishWithCode:(NSInteger)code message:(NSString *)message;
- (void)callbackRoutePlanDidFinished:(NSDictionary *)info;

// private - end

@end

NS_ASSUME_NONNULL_END
