//
//  BCAMapNavigateHandler.m
//  ChatAgentApp
//
//  Created by caoshiqian on 2025/4/20.
//

#import "BCAMapNavigateHandler.h"
#import "BCALocationManager.h"
#import "BCAMapNavigateModel.h"

@interface BCAMapNavigateHandler ()<BCAMapNavigateModelDelegate>

@property (nonatomic, strong) BCAFuncallItem *funcallItem;
@property (nonatomic, strong) BCAMapNavigateModel *navigateModel;

@end

@implementation BCAMapNavigateHandler

@synthesize delegate;

- (instancetype)init {
    if (self = [super init]) {
    }
    return self;
}

#pragma mark - Public

- (BCAFuncallItem *)funcallItem {
    return _funcallItem;
}

- (BCAFuncallResult)executeFuncallWithItem:(BCAFuncallItem *)item {
    if (self.funcallItem) {
        [self callbackResult:item.sessionId code:BCAFuncallResultFail error:@"正在导航中哦！"];
        return BCAFuncallResultSuccess;
    }
    
    self.funcallItem = item;
    self.navigateModel = [BCAMapNavigateModel modelWithParams:item.functionParams];
    self.navigateModel.delegate = self;
    if (!self.navigateModel) {
        [self callbackResult:item.sessionId code:BCAFuncallResultFail error:@"暂不支持该类型导航哦！"];
        return BCAFuncallResultSuccess;
    }
    
    [self.navigateModel startRoutePlan];
    return BCAFuncallResultSuccess;
}

- (BOOL)shouldExitFuncallHandler {
    return nil == [self funcallResultView];
}

- (BCAFuncallResultView *)funcallResultView {
    return (BCAFuncallResultView *)[self.navigateModel routePlanPreviewView];
}

- (void)onAgentAudioStateChange:(int)state {
    [self.navigateModel onAgentAudioStateChange:state];
}

#pragma mark - Private

- (void)callbackResult:(NSString *)sessionId code:(NSInteger)code error:(NSString *)errorStr {
    if (self.delegate) {
        NSError *error = code == BCAFuncallResultFail ? [NSError errorWithDomain:NSCocoaErrorDomain code:code userInfo:@{ NSLocalizedDescriptionKey: errorStr }] : nil;
        NSString *message = code == BCAFuncallResultFail ? nil : @"路线规划成功，点击查看详情";
        [self.delegate funcallHandler:self executeFinished:sessionId message:message error:error];
    }
}

#pragma mark - BCAMapNavigateModelDelegate

- (UIViewController *)mapNavigateModelGetChatViewController:(BCAMapNavigateModel *)model {
    if ([self.delegate respondsToSelector:@selector(funcallHandlerChatViewController:)]) {
        return [self.delegate funcallHandlerChatViewController:self];
    }
    return nil;
}

- (void)mapNavigateModel:(BCAMapNavigateModel *)model onPlayTTS:(NSString *)text {
    if ([self.delegate respondsToSelector:@selector(funcallHandler:sendTextToTTS:)]) {
        [self.delegate funcallHandler:self sendTextToTTS:text];
    }
}

- (void)mapNavigateModel:(BCAMapNavigateModel *)model routePlanDidFinished:(NSDictionary *)info {
    [self callbackResult:self.funcallItem.sessionId code:BCAFuncallResultSuccess error:nil];
}

- (void)mapNavigateModel:(BCAMapNavigateModel *)model finishWithError:(NSError *)error {
    [self callbackResult:self.funcallItem.sessionId code:BCAFuncallResultFail error:error.localizedDescription];
}

@end
