//
//  BCAFuncallDemoContent.m
//  ChatAgentApp
//
//  Created by caoshiqian on 2025/4/23.
//

#import "BCAFuncallDemoContent.h"

#ifdef DEBUG

@implementation BCAFuncallDemoContent

+ (NSString *)contentWithSessionId:(NSString *)sessionId defaultContent:(NSString *)defaultContent {
    NSDictionary *dict = nil;
    
//    dict = [[self class] mapNavigateNoStartSingleEnd];
//    dict = [[self class] mapPoiSearchCity];
//    dict = [[self class] mapPoiSearchNearby];
//    dict = [[self class] mapPoiSearchNearbyWithCenter];
    
    if (dict) {
        NSData *jsonData = [NSJSONSerialization dataWithJSONObject:dict options:0 error:nil];
        NSString *content = [[NSString alloc] initWithData:jsonData encoding:NSUTF8StringEncoding];
        content = [content stringByReplacingOccurrencesOfString:@"\"" withString:@"\\\""];
        NSString *params = [NSString stringWithFormat:@"{\"session_id\":\"%@\",\"content\":\"%@\"}", sessionId, content];
        return params;
    }
    return defaultContent;
}

+ (NSDictionary *)mapNavigateNoStartSingleEnd {
    return @{
        @"function_name": @"map_navigate",
        @"parameter_list": @[
            @{ @"navi_position": @"西直门,天安门" },
            @{ @"navi_type": @"drive" }
        ]
    };
}

+ (NSDictionary *)mapPoiSearchCity {
    return @{
        @"function_name": @"map_poi_search",
        @"parameter_list": @[
            @{ @"keyword": @"博物馆" },
            @{ @"center_position": @"北京" },
            @{ @"search_type": @"area" }
        ]
    };
}

+ (NSDictionary *)mapPoiSearchNearby {
    return @{
        @"function_name": @"map_poi_search",
        @"parameter_list": @[
            @{ @"keyword": @"餐厅" },
        ]
    };
}

+ (NSDictionary *)mapPoiSearchNearbyWithCenter {
    return @{
        @"function_name": @"map_poi_search",
        @"parameter_list": @[
            @{ @"keyword": @"餐厅" },
            @{ @"center_position": @"天坛" }
        ]
    };
}

@end

#endif
