function BaiduRtcAgentClient() {
    var AppID = '';
    var AgentID = '';
    var ak = undefined;
    var sk = undefined;
    var gAgentStarted = false;
    var AgentApiHost = 'https://ai.agent.kaywang.cn/api';
    this.Start = function (param) {
        AppID = param.appid;
        console.log('Agent.Start appid: ' + AppID);

        if (param.apihost) {
            AgentApiHost = param.apihost;
        }

        ak = param.ak;
        sk = param.sk;

        var xmlHttp = new XMLHttpRequest();
        xmlHttp.open('POST', AgentApiHost + '/v1/aiagent/generateAIAgentCall', true);
        xmlHttp.setRequestHeader('Content-Type', 'application/json');

        var data = {app_id: AppID,
                    quick_start: true,
                    instance_type: param.instance_type,
                    ak: param.ak,
                    sk: param.sk,
                    config: JSON.stringify(param.cfg)};

        var that_agent = this;

        xmlHttp.onreadystatechange = function () {
            if (xmlHttp.readyState === 4) {
                if (xmlHttp.status === 200) {
                    console.log(xmlHttp.responseText);
                    let response = JSON.parse(xmlHttp.responseText);
                    if (response.ai_agent_instance_id) {
                        gAgentStarted = true;
                        AgentID = response.ai_agent_instance_id;
                        var userID = AgentID;
                        var Token = response.context.token;

                        if (response.context && response.context.uid) {
                            userID = response.context.uid;
                        }

                        if (response.context && response.context.appid) {
                            AppID = response.context.appid;
                            param.appid = AppID;
                        }

                        that_agent.loginBRTC(Object.assign(param, {
                            roomname: AgentID,
                            userid: userID,
                            token: Token
                        }));
                    }
                }
            }
        };

        xmlHttp.send(JSON.stringify(data));
    };

    this.Stop = function () {
        var p = new Promise((resolve, reject) => {
            if (!gAgentStarted) {
                resolve();
            }
            gAgentStarted = false;
            console.log('Agent.Stop begin.');

            let xmlHttp = new XMLHttpRequest();
            xmlHttp.open('POST', AgentApiHost + '/v1/aiagent/stopAIAgentInstance', true);
            xmlHttp.setRequestHeader('Content-Type', 'application/json');
            let data = {app_id: AppID,
                        ai_agent_instance_id: AgentID,
                        ak: ak,
                        sk: sk
                       };

            xmlHttp.onreadystatechange = function () {
                if (xmlHttp.readyState === 4) {
                    if (xmlHttp.status === 200) {
                        console.log('Agent.Stop OK:' + xmlHttp.responseText);
                        resolve();
                    } else {
                        console.log('Agent.Stop failed:' + xmlHttp.responseText);
                        reject();
                    }
                }
            };
            xmlHttp.send(JSON.stringify(data));
            window.BRTC_Stop();
        });
        return p;

    };

    this.GetAgentID = function () {
        return AgentID;
    };

    this.loginBRTC = function (p) {
        BRTC_Start(
            Object.assign(p, {
            aspublisher: true,
            usingdatachannel: true,
            usingvideo: false,
            usingaudio: true,
            showvideobps: false,
            autosubscribe: true,
            autoplaymuted: false,
            autopublish: true,
            showspinner: false,
            shownovideo: false,
            userevent: true,
            sessionevent: true,
            linkdownevent: function () {
                console.log('linkdownevent');
            },
            linkupevent: function () {
                console.log('linkupevent');
            },
            logintimeout: 10000,
            logintimeoutevent: function () {
                console.log('timeout');
            },
            mediastate: function (medium, on) {
                console.log('send medium ' + medium + ' is: ' + on);
            },
            remotevideoon: function (idx) {
                console.log('remotevideoon, index:' + idx);
            },
            remotevideooff: function (idx) {
                console.log('remotevideooff, index:' + idx);
            },
            remotevideocoming: function (id, display, attribute) {
                console.log('remotevideocoming, feedid:' + id + ':' + display + ':' + attribute);

                var ua = navigator.userAgent.toLowerCase();
                if (ua.match(/MicroMessenger/i) === 'micromessenger' || ua.match(/WxWork/i) === 'wxwork') {
                    setTimeout((x) => {
                        const video = document.getElementById('remotevideo1');
                            if (video) {
                                video.play();
                            }
                        }, 1000);

                    setTimeout((x) => {
                        const w = document.getElementById('waitingvideo1');
                            if (w) {
                                w.height = 0;
                                const video = document.getElementById('remotevideo1');
                                if (video) {
                                    video.autoplay = false;
                                    video.playsinline = false;
                                    video.controls = true;
                                }
                            }
                        }, 3000);
                }
            },
            remotevideoloading: function (idx) {
                console.log('remotevideoloading, index:' + idx);
            },
            remotevideoconnected_state: function (id, on) {
                console.log('remotevideoconnected_state, feedid:' + id + ' connected:' + on);
            },
            remotevideoleaving: function (id) {
                console.log('remotevideoleaving, feedid:' + id);
            },
            remotevideounpublished: function (id) {
                console.log('remotevideounpublished, feedid:' + id);
            },
            localvideoconnected_state: function (on) {
                console.log('localvideoconnected_state, connected:' + on);
            },
            localvideopublished_ok: function () {
                console.log('localvideopublished_ok.');
            },
            destroyed: function (error) {

            },
            onlocalstream: function (stream, name) {
                // local stream for display sonic wave
                console.log('onlocalstream name: ' + name);
            },
            onlocalstream_end: function (name) {
                console.log('onlocalstream_end name: ' + name);
            },
            remotevideo_closed: function (feedid) {
                console.log('remotevideo_closed(feedid: ' + feedid + ') by server, please do SubScribing again');
            },
        }));
    };

    this.sendMessageToUser = function (msg, uid) {
        window.BRTC_SendMessageToUser(msg, uid);
    };

    this.Version = function () {
        return 'V1.0.7';
    };
}