package com.baidu.ai.sample.data;

import android.text.TextUtils;
import android.util.Log;

import org.json.JSONObject;

public class StartRequest {
    public static final String DH_TYPE = "DigitalHuman";
    public String appId;
    public boolean quickStart;
    public String config;

    public String instanceType;

    public StartRequest(String appId) {
        this.appId = appId;
        this.quickStart = true;
    }

    public void addConfig(AIClientData data) {
        JSONObject config = new JSONObject();
        Log.i("StartRequest", "AIClientData:" + data.dumpString() + ", instanceType:" + instanceType);

        try {
            if (!TextUtils.isEmpty(data.mLLMName)) {
                config.put("llm", data.mLLMName);
            }
            if (!TextUtils.isEmpty(data.mLLMUrl)) {
                config.put("llm_url", data.mLLMUrl);
            }
            if (!TextUtils.isEmpty(data.mLLMToken)) {
                config.put("llm_token", data.mLLMToken);
            }
            if (!TextUtils.isEmpty(data.mLLMCfg)) {
                config.put("llm_cfg", data.mLLMCfg);
            }

            if (!TextUtils.isEmpty(data.mLang)) {
                config.put("lang", data.mLang);
            }

            if (!TextUtils.isEmpty(data.mVoiceConfig)) {
                config.put("tts_url", data.mVoiceConfig);
            }

            if (!TextUtils.isEmpty(data.mRole)) {
                config.put("role", data.mRole);
            }

            if (!TextUtils.isEmpty(data.mSense)) {
                config.put("sceneRole", data.mSense);
            }

            if (!TextUtils.isEmpty(data.mSay)) {
                config.put("tts_sayhi", data.mSay);
            }

            if (!TextUtils.isEmpty(data.mFigureId)) {
                config.put("fid", data.mFigureId);
            }

            if (!TextUtils.isEmpty(data.mLocation)) {
                config.put("location", data.mLocation);
            } else if (!TextUtils.isEmpty(data.mCoordinate)) {
                config.put("gis", data.mCoordinate);
            }
            if (!TextUtils.isEmpty(data.mAudioCodec)) {
                config.put("audiocodec", data.mAudioCodec);
            }
            if (!TextUtils.isEmpty(data.mInterruptWords)) {
                config.put("interruption_words", data.mInterruptWords);
            }
            if (data.mTTSEndDelayMs > 0) {
                config.put("tts_end_delay_ms", data.mTTSEndDelayMs);
            }

            if (!TextUtils.isEmpty(data.mVoiceFpURL)) {
                JSONObject json = new JSONObject(data.mVoiceFpURL);
                config.put("voice_fp_url", json);
            }

            if (TextUtils.equals(instanceType, DH_TYPE)) {
                config.put("tts", "DHV2");
            }

        } catch (Exception e) {
            e.printStackTrace();
        }

        if (config.length() > 0) {
            this.config = config.toString();
            Log.i("StartRequest", "config:" + config);
        }

    }
    public String toJson() {

        JSONObject root = new JSONObject();
        try {
            root.put("app_id", this.appId);
            root.put("quick_start", this.quickStart);
            if (!TextUtils.isEmpty(this.config)) {
                root.put("config", this.config);
            }
            if (!TextUtils.isEmpty(instanceType)) {
                root.put("instance_type", instanceType);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return root.toString();
    }

}
