/*
 * Copyright (C) 2025 Baidu, Inc. All Rights Reserved.
 */
package com.baidu.ai.sample.data;

import java.util.List;

public class CharacterData {
    private CustomData custom;

    public CustomData getCustom() {
        return custom;
    }

    public void setCustom(CustomData custom) {
        this.custom = custom;
    }

    public static class CustomData {
        private String nameCh;
        private String nameEn;
        private List<ChineseComment> commentsCh;
        private EnglishComment commentsEn;

        // getters and setters
        public String getNameCh() {
            return nameCh;
        }

        public void setNameCh(String nameCh) {
            this.nameCh = nameCh;
        }

        public String getNameEn() {
            return nameEn;
        }

        public void setNameEn(String nameEn) {
            this.nameEn = nameEn;
        }

        public List<ChineseComment> getCommentsCh() {
            return commentsCh;
        }

        public void setCommentsCh(List<ChineseComment> commentsCh) {
            this.commentsCh = commentsCh;
        }

        public EnglishComment getCommentsEn() {
            return commentsEn;
        }

        public void setCommentsEn(EnglishComment commentsEn) {
            this.commentsEn = commentsEn;
        }
    }

    public static class ChineseComment {
        private String name;
        private int strokenumber;
        private String radical;
        private String comment;
        private String exampleSentence;

        // getters and setters
        public String getName() {
            return name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getStrokenumber() {
            return strokenumber;
        }

        public void setStrokenumber(int strokenumber) {
            this.strokenumber = strokenumber;
        }

        public String getRadical() {
            return radical;
        }

        public void setRadical(String radical) {
            this.radical = radical;
        }

        public String getComment() {
            return comment;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }

        public String getExampleSentence() {
            return exampleSentence;
        }

        public void setExampleSentence(String exampleSentence) {
            this.exampleSentence = exampleSentence;
        }
    }

    public static class EnglishComment {
        private String name;
        private String soundmarkUs;
        private String soundmarkEn;
        private String comment;
        private String exampleSentence;

        // getters and setters
        public String getName() {
            return name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getSoundmarkUs() {
            return soundmarkUs;
        }

        public void setSoundmarkUs(String soundmarkUs) {
            this.soundmarkUs = soundmarkUs;
        }

        public String getSoundmarkEn() {
            return soundmarkEn;
        }

        public void setSoundmarkEn(String soundmarkEn) {
            this.soundmarkEn = soundmarkEn;
        }

        public String getComment() {
            return comment;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }

        public String getExampleSentence() {
            return exampleSentence;
        }

        public void setExampleSentence(String exampleSentence) {
            this.exampleSentence = exampleSentence;
        }
    }
}
