package com.baidu.ai.sample.data;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Parcel;
import android.os.Parcelable;
import android.preference.PreferenceManager;
import android.text.TextUtils;

import com.baidu.ai.sample.R;
import com.baidu.ai.sample.util.Utils;
import com.baidu.rtc.RtcParameterSettings;

import org.json.JSONObject;

public class AIClientData implements Parcelable {
    private static final String TAG = AIClientData.class.getSimpleName();
    public String mAppId = "";
    public String mContext = "";
    public String mTokenStr = "";
    public String mInstanceId = "";

    public String mInterruptWords = "";

    public String mAudioCodec = RtcParameterSettings.AudioCodecId.OPUS;
    /*** 切换不同编码器 */
//    public String mAudioCodec = RtcParameterSettings.AudioCodecId.PCMU;

    public String mLLMName = "";
    public String mLLMUrl = "";
    public String mLLMCfg = "";
    public String mLLMToken = "";

    public String mVoiceConfig = "";
    public String mLang = "";

    public String mRole = "";

    public String mSense = "";


    public String mMode = "";

    public String mSay = "";

    public String mFigureId = "";

    public String mLocation = "";

    public String mCoordinate = "";

    // 增强query插入类型包括:不插入、前插、后插、前后双插
    public String mQueryEnhanceType;

    // 增强query前插文本
    public String mPreQuery;

    // 增强query后插文本
    public String mPostQuery;
    public String mUserID;
    public String mLicenseKey;

    public String mVoiceFpURL;

    public String mHintHistory;


    /** TTS_END_SPEAKING 延时 200ms */
    public int mTTSEndDelayMs = 200;

    public AIClientData() {
    }
    protected AIClientData(Parcel in) {
        mAppId = in.readString();
        mContext = in.readString();
        mTokenStr = in.readString();
        mInstanceId = in.readString();
        mInterruptWords = in.readString();
        mAudioCodec = in.readString();
        mLLMName = in.readString();
        mLLMUrl = in.readString();
        mLLMCfg = in.readString();
        mLLMToken = in.readString();
        mVoiceConfig = in.readString();
        mLang = in.readString();
        mRole = in.readString();
        mSense = in.readString();
        mMode = in.readString();
        mSay = in.readString();
        mLocation = in.readString();
        mCoordinate = in.readString();
        mQueryEnhanceType = in.readString();
        mPreQuery = in.readString();
        mPostQuery = in.readString();
        mUserID = in.readString();
        mLicenseKey = in.readString();
        mVoiceFpURL = in.readString();
        mHintHistory = in.readString();
        mTTSEndDelayMs = in.readInt();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(mAppId);
        dest.writeString(mContext);
        dest.writeString(mTokenStr);
        dest.writeString(mInstanceId);
        dest.writeString(mInterruptWords);
        dest.writeString(mAudioCodec);
        dest.writeString(mLLMName);
        dest.writeString(mLLMUrl);
        dest.writeString(mLLMCfg);
        dest.writeString(mLLMToken);
        dest.writeString(mVoiceConfig);
        dest.writeString(mLang);
        dest.writeString(mRole);
        dest.writeString(mSense);
        dest.writeString(mMode);
        dest.writeString(mSay);
        dest.writeString(mLocation);
        dest.writeString(mCoordinate);
        dest.writeString(mQueryEnhanceType);
        dest.writeString(mPreQuery);
        dest.writeString(mPostQuery);
        dest.writeString(mUserID);
        dest.writeString(mLicenseKey);
        dest.writeString(mVoiceFpURL);
        dest.writeString(mHintHistory);
        dest.writeInt(mTTSEndDelayMs);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static final Creator<AIClientData> CREATOR = new Creator<AIClientData>() {
        @Override
        public AIClientData createFromParcel(Parcel in) {
            return new AIClientData(in);
        }

        @Override
        public AIClientData[] newArray(int size) {
            return new AIClientData[size];
        }
    };

    public static final String KEY_APP_ID = "key_appid";
    public static final String KEY_TOKEN = "key_token";
    public static final String KEY_USER_ID = "key_user_id";
    public static final String KEY_LICENSE_KEY = "key_license_key";

    public static final String KEY_VOICE_FP_URL_KEY = "key_voice_fp_url";

    public static final String KEY_SCENE_ROLE_ID = "key_scene_role_id";

    public static final String KEY_HINT_HISTORY_ID = "key_hint_history_url";

    public static final String KEY_INSTANCE_ID = "key_instance_id";

    public static final String KEY_INTERRUPTION_WORDS = "key_interruption_words";

    /** 读取缓存信息 */
    public void readCacheData(Context context) {
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences(context);
        mAppId = prefs.getString(KEY_APP_ID, context.getString(R.string.agent_default_app_id));
        mTokenStr = prefs.getString(KEY_TOKEN, context.getString(R.string.baidu_rtc_token_tmp));
        mUserID = prefs.getString(KEY_USER_ID, "");
        mLicenseKey = prefs.getString(KEY_LICENSE_KEY, "");
        mInstanceId = prefs.getString(KEY_INSTANCE_ID, String.valueOf(Utils.getDeviceId()));
        mInterruptWords = prefs.getString(KEY_INTERRUPTION_WORDS, "");
        mVoiceFpURL = prefs.getString(KEY_VOICE_FP_URL_KEY, "");
        mHintHistory = prefs.getString(KEY_HINT_HISTORY_ID, "");
        mSense = prefs.getString(KEY_SCENE_ROLE_ID, "");

        if (!TextUtils.isEmpty(mInstanceId)) {
            try {
                SharedPreferences.Editor editor =  prefs.edit();
                editor.putString("key_instance_id", mInstanceId);
                editor.apply();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        checkData(context);
    }

    public void parseIntent(Context context, String config) {
        if (TextUtils.isEmpty(config)) {
            return;
        }
        try {
            SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences(context);
            SharedPreferences.Editor editor =  prefs.edit();

            JSONObject root = new JSONObject(config);
            String appId = root.optString(KEY_APP_ID, "");
            if (!TextUtils.isEmpty(appId)) {
                editor.putString(KEY_APP_ID, appId);
                mAppId = appId;
            }
            String userId = root.optString(KEY_USER_ID, "");
            if (!TextUtils.isEmpty(userId)) {
                editor.putString(KEY_USER_ID, userId);
                mUserID = userId;
            }

            String licenseKey = root.optString(KEY_LICENSE_KEY, "");
            if (!TextUtils.isEmpty(licenseKey)) {
                editor.putString(KEY_LICENSE_KEY, licenseKey);
                mLicenseKey = licenseKey;
            }

            String words = root.optString(KEY_INTERRUPTION_WORDS, "");
            if (!TextUtils.isEmpty(words)) {
                editor.putString(KEY_INTERRUPTION_WORDS, words);
                mInterruptWords = words;
            }

            String voiceFp = root.optString(KEY_VOICE_FP_URL_KEY, "");
            if (!TextUtils.isEmpty(voiceFp)) {
                editor.putString(KEY_VOICE_FP_URL_KEY, voiceFp);
                mVoiceFpURL = voiceFp;
            }

            String hintHistory = root.optString(KEY_HINT_HISTORY_ID, "");
            if (!TextUtils.isEmpty(hintHistory)) {
                editor.putString(KEY_HINT_HISTORY_ID, hintHistory);
                mHintHistory = hintHistory;
            }

            String sceneRole = root.optString(KEY_SCENE_ROLE_ID, "");
            if (!TextUtils.isEmpty(sceneRole)) {
                editor.putString(KEY_SCENE_ROLE_ID, sceneRole);
                mSense = sceneRole;
            }

            editor.apply();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    public void checkData(Context context) {

        if (TextUtils.isEmpty(mAppId)) {
            mAppId = context.getString(R.string.agent_default_app_id);
        }
    }

    public String dumpString() {
        StringBuilder sb = new StringBuilder();
        sb.append("appId:" + mAppId + ", ");
        sb.append("token:" + mTokenStr + ", ");
        sb.append("instanceId:" + mInstanceId + ", ");
        sb.append("config:" + mContext + ", ");
        sb.append("llm:" + mLLMName + ", ");
        sb.append("loc:" + mLocation + ", ");
        sb.append("say:" + mSay + ", ");
        sb.append("lang:" + mLang + ", ");
        sb.append("queryEnhanceType" + mQueryEnhanceType + ", ");
        sb.append("preQuery" + mPreQuery + ", ");
        sb.append("postQuery" + mPostQuery + ", ");
        sb.append("userId:" + mUserID + ", ");
        sb.append("licenseKey:" + mLicenseKey + ", ");
        sb.append("interrupt:" + mInterruptWords + ", ");
        sb.append("senseRole:" + mSense + ", ");
        sb.append("hint_history:" + mHintHistory + ", ");


        return sb.toString();
    }
}
