/*
 * Copyright (C) 2024 Baidu, Inc. All Rights Reserved.
 */
package com.baidu.ai.sample.cloudrender;

import java.util.HashMap;
import java.util.Map;

import org.json.JSONObject;

public class DestroyCloudStreamingRequest extends CloudRenderRequest {

    String path = "command/pad/execute-script.html";
    String scriptContent = "am start-foreground-service -a 'com.baidu.rtc.gameroom.GameRoomService' -d 'brtc://close_room'";

    public DestroyCloudStreamingRequest(String appKey, String appSecret, String desKey) {
        super(appKey, appSecret, desKey);
    }

    @Override
    protected String getPath() {
        return path;
    }

    @Override
    protected String generateRequestParam() {
        scriptContent = String.format(
                "am start-foreground-service -a 'com.baidu.rtc.gameroom.GameRoomService' -d 'brtc://close_room?roomName=%s'",
                instanceId);
        Map<String, Object> param = new HashMap<>();
        param.put("padCodes", cloudPhoneInstanceIds);
        param.put("scriptContent", scriptContent);
        String requestParam = new JSONObject(param).toString();
        return requestParam;
    }
}
