/*
 * Copyright (C) 2024 Baidu, Inc. All Rights Reserved.
 */
package com.baidu.ai.sample.cloudrender;

import java.util.HashMap;
import java.util.Map;

import org.json.JSONObject;

public class  CreateCloudStreamingRequest extends CloudRenderRequest {
    private String uid = "123888";
    private String path = "command/pad/execute-script.html";
    private String appId = "";

    public CreateCloudStreamingRequest(String appKey, String appSecret, String desKey) {
        super(appKey, appSecret, desKey);
    }

    @Override
    protected String getPath() {
        return path;
    }

    public String setCloudRenderUid(String uid) {
        return this.uid = uid;
    }

    public String setRtcAppId(String appId) {
        return this.appId = appId;
    }

    private String generateScriptContent() {
        return String.format(
            "am start-foreground-service -a 'com.baidu.rtc.gameroom.GameRoomService' -d "
                    + "'brtc://join_room?roomName=%s&userId=%s&videoCodec=h264&appId=%s'",
            instanceId, uid, appId);
    }

    @Override
    protected String generateRequestParam() {
        // 填装实际接口请求参数
        Map<String, Object> param = new HashMap<>();
        param.put("padCodes", cloudPhoneInstanceIds);
        param.put("scriptContent", generateScriptContent());
        String requestParam = new JSONObject(param).toString();
        return requestParam;
    }
}
