package com.baidu.ai.sample;

import android.annotation.SuppressLint;
import android.os.Bundle;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import androidx.appcompat.app.AppCompatActivity;

public class WebViewActivity extends AppCompatActivity {

    private WebView webView;

    @SuppressLint("SetJavaScriptEnabled")
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_webview);

        webView = findViewById(R.id.webView);

        // 获取传递过来的 URL
        String url = getIntent().getStringExtra("URL");

        if (url != null) {
            // WebView 设置
            WebSettings webSettings = webView.getSettings();
            webSettings.setJavaScriptEnabled(true); // 启用 JavaScript
            webSettings.setDomStorageEnabled(true); // 启用本地存储
            webSettings.setLoadWithOverviewMode(true);
            webSettings.setLoadsImagesAutomatically(true);
            webSettings.setBlockNetworkImage(false);
            webSettings.setUseWideViewPort(true);
            webSettings.setMixedContentMode(WebSettings.MIXED_CONTENT_ALWAYS_ALLOW);

            // 在 WebView 内部打开网页，而不是使用外部浏览器
            webView.setWebViewClient(new WebViewClient());

            // 加载网页
            webView.loadUrl(url);
        }
    }

    @Override
    protected void onPause() {
        super.onPause();
        // 暂停 WebView 的渲染和 JavaScript 执行
        if (webView != null) {
            webView.onPause();
        }
    }

    @Override
    protected void onResume() {
        super.onResume();
        // 恢复 WebView 的渲染和 JavaScript 执行
        if (webView != null) {
            webView.onResume();
        }
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        // 释放 WebView 资源并停止所有正在播放的媒体
        if (webView != null) {
            webView.destroy();
            webView = null;
        }
    }

    @Override
    public void onBackPressed() {
        // 处理 WebView 的返回逻辑
        if (webView.canGoBack()) {
            webView.goBack();
        } else {
            super.onBackPressed();
        }
    }
}
