package com.baidu.ai.sample;

import android.app.Application;
import android.content.Context;
import androidx.multidex.MultiDex;

import com.baidu.ai.sample.data.ContextConstant;
import com.baidu.ai.sample.util.CrashUtil;
import com.tencent.bugly.crashreport.CrashReport;

public class BDApplication extends Application {
    private static final String TAG = "BDApplication";
    @Override
    public void onCreate() {
        super.onCreate();
        Context context = getApplicationContext();

        ContextConstant.setContext(context);

        new CrashUtil().initCrashHandler();
        CrashReport.initCrashReport(context, "656b522d12", false);
    }

    @Override
    protected void attachBaseContext(Context base) {
        super.attachBaseContext(base);
        MultiDex.install(base);
    }
}
