package com.baidu.ai.sample.util;


import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.provider.MediaStore;
import android.provider.OpenableColumns;

import com.baidu.rtc.model.Constants;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class Utils {

    /** 获取设备uid */
    public static int getDeviceId() {
        return 78657895 + (Build.SERIAL.hashCode() % 100000) + (int) (Math.random() * 10000);
    }

    public static String getStateString(int state) {
        String result = "";
        switch (state) {
            case Constants.CONNECTION_STATE_DISCONNECTED: {
                result = "CONNECTION_STATE_DISCONNECTED";
                break;
            }
            case Constants.CONNECTION_STATE_CONNECTING: {
                result = "CONNECTION_STATE_CONNECTING";
                break;
            }
            case Constants.CONNECTION_STATE_CONNECTED: {
                result = "CONNECTION_STATE_CONNECTED";
                break;
            }
            case Constants.CONNECTION_STATE_RECONNECTING: {
                result = "CONNECTION_STATE_RECONNECTING";
                break;
            }
            case Constants.ERR_LOGIN_ROOM_PARAMS: {
                result = "ERR_LOGIN_ROOM_PARAMS";
                break;
            }
            case Constants.ERR_CHANNEL_IO_EXCEPTION: {
                result = "ERR_CHANNEL_IO_EXCEPTION";
                break;
            }
            case Constants.ERR_CHANNEL_DISCARD_BY_REMOTE: {
                result = "ERR_CHANNEL_DISCARD_BY_REMOTE";
                break;
            }
            case Constants.ERR_AUDIO_DEVICE_RECORD: {
                result = "ERR_AUDIO_DEVICE_RECORD";
                break;
            }
            case Constants.RTC_STATE_STREAM_SLOW_LINK_LEVEL0: {
                result = "RTC_STATE_STREAM_SLOW_LINK_LEVEL0";
                break;
            }
            case Constants.RTC_STATE_STREAM_SLOW_LINK_LEVEL1: {
                result = "RTC_STATE_STREAM_SLOW_LINK_LEVEL1";
                break;
            }
            case Constants.RTC_STATE_STREAM_SLOW_LINK_LEVEL2: {
                result = "RTC_STATE_STREAM_SLOW_LINK_LEVEL2";
                break;
            }
            case Constants.RTC_STATE_STREAM_SLOW_LINK_LEVEL3: {
                result = "RTC_STATE_STREAM_SLOW_LINK_LEVEL3";
                break;
            }
            case Constants.RTC_STATE_STREAM_SLOW_LINK_LEVEL4: {
                result = "RTC_STATE_STREAM_SLOW_LINK_LEVEL4";
                break;
            }
            case Constants.RTC_STATE_STREAM_SLOW_LINK_LEVEL5: {
                result = "RTC_STATE_STREAM_SLOW_LINK_LEVEL5";
                break;
            }
            case Constants.RTC_STATE_STREAM_SLOW_LINK_LEVEL6: {
                result = "RTC_STATE_STREAM_SLOW_LINK_LEVEL6";
                break;
            }
            case Constants.RTC_STATE_STREAM_SLOW_LINK_LEVEL7: {
                result = "RTC_STATE_STREAM_SLOW_LINK_LEVEL7";
                break;
            }
            case Constants.RTC_STATE_STREAM_SLOW_LINK_LEVEL8: {
                result = "RTC_STATE_STREAM_SLOW_LINK_LEVEL8";
                break;
            }
            case Constants.RTC_STATE_STREAM_SLOW_LINK_LEVEL9: {
                result = "RTC_STATE_STREAM_SLOW_LINK_LEVEL9";
                break;
            }
            default: {
                result = "unknow state!";
                break;
            }
        }
        return result;
    }

    public static String getAbsolutePath(Context context, Intent intent) {
        String filePath = null;
        Uri uri = intent.getData();
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.Q) {
            ContentResolver contentResolver = context.getContentResolver();
            Cursor cursor = contentResolver.query(uri, null, null, null, null);

            try {
                if (cursor != null && cursor.moveToFirst()) {
                    int displayNameIndex = cursor.getColumnIndex(OpenableColumns.DISPLAY_NAME);
                    String displayName = cursor.getString(displayNameIndex);
                    InputStream inputStream = contentResolver.openInputStream(uri);
                    if (inputStream != null) {
                        File file = new File(context.getCacheDir(), displayName);
                        FileOutputStream outputStream = new FileOutputStream(file);
                        byte[] buffer = new byte[1024];
                        int length;
                        while ((length = inputStream.read(buffer)) > 0) {
                            outputStream.write(buffer, 0, length);
                        }
                        outputStream.close();
                        inputStream.close();
                        filePath = file.getAbsolutePath();
                    }
                }
            } catch (IOException e) {
                e.printStackTrace();
            } finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        } else {
            String[] projection = { MediaStore.Images.Media.DATA };
            Cursor cursor = context.getContentResolver().query(uri, projection, null, null, null);

            if (cursor != null) {
                int columnIndex = cursor.getColumnIndexOrThrow(MediaStore.Images.Media.DATA);
                cursor.moveToFirst();
                filePath = cursor.getString(columnIndex);
                cursor.close();
            }
        }

        return filePath;
    }

}
