package com.baidu.ai.sample.data;

import android.text.TextUtils;

import org.json.JSONObject;

public class StartResponse {
    public long instanceId;
    public String token;
    public String instanceType;
    public String context;

    public StartResponse(String content) {
        parse(content);
    }

    public boolean parse(String text) {
        try {
            JSONObject root = new JSONObject(text);
            instanceId = root.optLong("ai_agent_instance_id", 0);
            instanceType = root.optString("instance_type", "");
            context = root.optString("context", "");
            if (!TextUtils.isEmpty(context)) {
                JSONObject ext = new JSONObject(context);
                token = ext.optString("token", "");
            }
            return true;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }
}
