# Add project specific ProGuard rules here.
# By default, the flags in this file are appended to flags specified
# in /Users/crossle/Library/Android/sdk/tools/proguard/proguard-android.txt
# You can edit the include path and order by changing the proguardFiles
# directive in build.gradle.
#
# For more details, see
#   http://developer.android.com/guide/developing/tools/proguard.html

# Add any project specific keep options here:

# If your project uses WebView with JS, uncomment the following
# and specify the fully qualified class name to the JavaScript interface
# class:
#-keepclassmembers class fqcn.of.javascript.interface.for.webview {
#   public *;
#}

# Uncomment this to preserve the line number information for
# debugging stack traces.
#-keepattributes SourceFile,LineNumberTable

# If you keep the line number information, uncomment this to
# hide the original source file name.
#-renamesourcefileattribute SourceFile


#-dontoptimize
-ignorewarnings
-optimizationpasses 5
-dontusemixedcaseclassnames
-dontskipnonpubliclibraryclasses
-dontskipnonpubliclibraryclassmembers
-dontpreverify
-verbose
-printmapping proguardMapping.txt
-dontshrink
-dontwarn android.support.annotation.Keep
-keep @android.support.annotation.Keep class **{
    @android.support.annotation.Keep <fields>;
    @android.support.annotation.Keep <methods>;
}
-optimizations !code/simplification/arithmetic,!code/simplification/cast,!field/*,!class/merging/*


##############Proguard for license##################
-keep class com.baidu.license.** { *; }
##############Proguard for arface##################
-keep class com.baidu.minivideo.arface.** { *; }
##############Proguard for ar##################
-keep class com.baidu.ar.** { *; }

-keepclassmembernames class ** {
    okhttp3.Response intercept(okhttp3.Interceptor$Chain);
}


-dontwarn okio.**
-dontwarn com.squareup.okhttp.**
-dontwarn okhttp3.**
-dontwarn javax.annotation.**
-dontwarn com.android.volley.toolbox.**
-dontwarn com.facebook.infer.**

# okHttp
-keep class okhttp3.** { *; }
-keep interface okhttp3.** { *; }
-keep interface okhttp3.Interceptor$* { *; }
-dontwarn okhttp3.**

-keep class okio.** { *; }
-keep interface okio.** { *; }
-dontwarn okio.**

-keep class javax.annotation.** {*;}

# bugly
-dontwarn com.tencent.bugly.**
-keep public class com.tencent.bugly.**{*;}