package com.baidu.ai.sample;

import android.text.TextUtils;
import android.util.Log;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class HttpClient {
    private static final String TAG = "HttpClient";
    /** 正式域名： https://ai.agent.kaywang.cn */
    
    public static final String HOST = "https://ai.agent.kaywang.cn";
    public static final int HTTP_SUCCESS = 200;
    public static final String START_PATH = "/api/v1/aiagent/generateAIAgentCall";
    public static final String STOP_PATH = "/api/v1/aiagent/stopAIAgentInstance";

    public static final String DH_START_PATH = "/dh/v1/aiagent/generateAIAgentCall";
    public static final String DH_STOP_PATH = "/dh/v1/aiagent/stopAIAgentInstance";

    private OkHttpClient mClient;
    private ExecutorService mExecutor;

    public HttpClient() {
        mClient = new OkHttpClient();
        mExecutor = Executors.newSingleThreadScheduledExecutor();
    }

    public void apiJsonBody(String url, String json, Map<String, String> headers, Callback callback) {
        try {
            RequestBody body = RequestBody.create(MediaType.parse("application/json"), json);
            Request request = null;
            if (headers == null || headers.size() == 0) {
                request = new Request.Builder()
                        .url(url)
                        .post(body)
                        .build();
            } else {
                Request.Builder builder = new Request.Builder()
                        .url(url)
                        .post(body);

                for (String key : headers.keySet()) {
                    String val = headers.get(key);
                    if (TextUtils.isEmpty(key) || TextUtils.isEmpty(val)) {
                        continue;
                    }
                    builder.addHeader(key, val);
                }
                request = builder.build();
            }
            Log.i(TAG, " apiJsonBody:" + url + ", req:" + json);
            try (Response response = mClient.newCall(request).execute()) {
                int code = response.code();
                String res = response.body().string();
                if (callback != null) {
                    callback.onResponse(code, res);
                }
                Log.i(TAG, " apiJsonBody:" + url + ", res:" + res);
            } catch (Exception e) {
                e.printStackTrace();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean asyncApiJsonBody(String url, String json, Callback callback) {
        if (mExecutor.isShutdown()) {
            return false;
        }
        mExecutor.submit(new Runnable() {
            @Override
            public void run() {
                apiJsonBody(url, json, new HashMap<String, String>(), callback);
            }
        });
        return true;
    }

    public void onDestroy() {
        mExecutor.shutdown();
        Log.i(TAG, "HttpClient onDestroy");
    }

    public interface Callback {
        void onResponse(int code, String res);
    }
}
